#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Fork Tunel aber icalchemy 858Mod01.fsh    by     icalchemy 
//https://www.shadertoy.com/view/WfB3D1
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// lembro que em 28/07/2023 eu não fazia muita ideia de como fazer isso
// https://www.shadertoy.com/view/mlXyDn
// shaders lindos ♥ https://www.shadertoy.com/playlist/cXBGzV


#define R iResolution.xy  
// R is defined as the xy components of the screen resolution

#define rot(a) mat2(cos(a + vec4(0, 11, 33, 0)))  
// Macro to create a rotation matrix – note how the input angle “a” is offset by various constants.
// (This appears intended for rotating coordinates, though in this shader its direct usage isn’t obvious.)

#define blue vec4(1, 4, 8, 0) / 30.  
// Defines a blue color vector. The values are scaled down so that it remains subtle.

#define white vec4(.3)  
// Defines a white color vector with all components set to 0.3 (giving a soft white tone)

#define t  iTime * .8  
// A time variable “t”, scaled from iTime, driving the animation through the shader



// Global constants controlling the wavy paths for the tunnels:
const float freqA = .7;  // Frequency for the first path oscillation  
const float freqB = .4;  // Frequency for the second path oscillation  
const float ampA = 1.2;  // Amplitude for the first path  
const float ampB = 1.;   // Amplitude for the second path

// Global variables to hold color and glow information:
vec4 cor;      // Final color used by the distance field
float bl1, bl2; // Distance values for specific features (the white orb and red light)

//------------------------------------------------------------
// Function: path
// Returns a 2D position based on a sine and cosine function of z, forming a curved path.
vec2 path(in float z) {
    return vec2(
        ampA * sin(z * freqA), 
        ampB * cos(z * freqB)
    );
}

// Function: path2
// Provides an alternate 2D path, with slightly different parameters to introduce variation.
vec2 path2(float z) {
    return vec2(
        ampB * sin(z * freqB * .8), 
        ampA * cos(z * freqA * .2)
    );
}

//------------------------------------------------------------
// Function: textura
// This function builds a procedural “texture” effect by iteratively distorting the space.
// It uses a while-loop that increases a factor “a” (doubling each time) to sum up a noise-like effect.
float textura(vec3 p) {
    float d = 0., a = .4;
    vec3 f;
    while(a < 64.) {
        f = p * a * 8.;         // Scale the position by the increasing factor
        f.y -= t * 1.4;         // Offset in y by time to animate the texture
        d -= abs(dot(sin(f), p / p)) / a; // Compute a noise contribution (p/p yields a constant vec if nonzero)
        a += a;                 // Double a each iteration
    }
    return d;
}

//------------------------------------------------------------
// Function: map
// The heart of the shader – a distance estimator (or “map”) that returns a scalar field.
// It calculates distances from the point p to the two paths, incorporates procedural texture,
// and computes additional features for glow effects (bl1 and bl2).
float map(vec3 p) {
    // Calculate difference vectors from the current point to the two paths:
    vec2 t1 = p.xy - path(p.z);
    vec2 t2 = p.xy - path2(p.z);
    
    // The texture contributes a small displacement to the distance field:
    float e = .04 * textura(p);
    
    // d1 and d2 represent radial distances to the centers defined by the paths:
    float d1 = length(t1);
    float d2 = length(t2.y); // Note: t2.y is a scalar; length(x) returns abs(x)
    
    // Define time-variant offsets to inject movement along the z-axis:
    float b1 = tanh(cos(.9 * t) * 4.) * (4. + cos(2.3 * t)) + t + 6.;
    float b2 = sin(2. * t) * 3. + t + 5.;
    
    // k is used to compute the location of a key glowing feature:
    vec3 k;
    k.xy = path(b1) 
            + tanh(
                  vec2(
                      tanh(cos(1. * t) * 3. - 2.), 
                      sin(2. * t)
                  ) * 3.
              ) * .5; 
    k.z = b1;
           
    // bl1 and bl2 are distances used for adding glow effects to the scene:
    bl1 = length(p - k) - .2;
    bl2 = length((p - vec3(path2(b2), b2)).xz) - .1;

    // Mix between white and blue tones based on distance d1 using smoothstep for a soft transition:
    cor = mix(white, blue, smoothstep(-.1, .1, d1 * 2. - 1.9) - .3);
    
    // Return the minimum distance from either of the tunnel walls (or additional features) adjusted by e:
    return min(1.05 - min(d2, min(d1, 1.)) + e, min(bl1, bl2));
}

//------------------------------------------------------------
// Function: mainImage
// The main shader function executed per pixel. It sets up the camera, performs ray marching,
// and computes the final pixel color.
#define o fragColor
#define u fragCoord
//void mainImage(out vec4 o, vec2 u) {
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Variable declarations:
    vec3 col, p, lookAt, fw, rt, up, D;
    float s = 1., d, i = 0.;  // 's' will be the step distance for ray marching and 'i' iteration counter
    
    // Set the camera's target ("lookAt") along the moving tunnel path:
    lookAt.z  = t;
    lookAt.xy = path(lookAt.z);
    
    // Position the camera slightly behind the target on the path:
  p.z = t - exp((iMouse.y*12. / iResolution.y)*.1);
    p.xy = path(p.z);

    // Compute the initial view direction:
    D = normalize(lookAt - p);
    
    // Derive a right (rt) vector perpendicular to the view direction (in the xz-plane):
    rt = vec3(D.z, 0, -D.x);
    
    // Adjust the view direction D using the pixel offset from the center,
    // constructing a basic camera projection:
    // mat2x3(rt, cross(D, rt)) essentially generates a 2D basis from the right and up directions.
    D += mat2x3(rt, cross(D, rt)) * (u - R/2.) / R.y;
    
    // Ray marching loop: iterate until we either reach a maximum number of steps or
    // the sampling step length (s) becomes very small.
    while(i++ < 42. && s > .001) {
        s = map(p) * .5;  // Obtain the next step size from the distance field (halved for stability)
        p += s * D;       // March along the ray
    }
    
    // The initial color is based on the mixed value computed in map():
    fragColor = cor;
    
    // Adding brightness proportional to the number of iterations — fewer steps result in a brighter pixel:
    o += 3.5 / i;
    
    // Add a glowing white orb effect by applying an exponential falloff on bl1:
    o += .8 * exp(-bl1);
    
    // Enhance the red channel to simulate a red-shining light using the distance bl2:
    o.r += .8 * exp(-bl2);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

